clear all;

%   Author: Harold Christopher Burger
%   Date:   April 8, 2013.

addpath('BM3D/');
addpath('MLP/');


%sigma = 10;
%sigma = 25;
%sigma = 35;
sigma = 50;
%sigma = 75;
%sigma = 170;

% parameters for the Neural network performing the combination. Using a step
% size of 1 might yield somewhat better results, at the expense of much longer
% computation times.
params_combine = {}; 
params_combine.weightsSig = 2.0; 
params_combine.step = 3; 
params_combine.name = sprintf('combine_sig%d',sigma);

% load whitening stuff
load(sprintf('means_sig%d.mat',sigma));
load(sprintf('W_sig%d.mat',sigma));


% parameters for MLP. Using a step size of 1 might yield somewhat better
% results, at the expense of much longer computation times.
params_MLP = {};
params_MLP .weightsSig = 2;
params_MLP .step = 3;



% load an image
im = double(imread('house.png'));
rand('seed',0);
randn('seed',0);
im_noisy = im + sigma*randn(size(im));
psnr_noisy = getPSNR(im_noisy, im, 255);





% denoise with BM3D
fprintf('Denoising with BM3D ... ');
tstart_bm3d = tic;
[NA, im_denoised_bm3d] = BM3D(1, im_noisy/255, sigma);
im_denoised_bm3d = im_denoised_bm3d*255;
tstop_bm3d = toc(tstart_bm3d);
fprintf('Done. Took %f seconds. PSNR: %.2fdB\n',tstop_bm3d,getPSNR(im_denoised_bm3d,im,255));


% denoise with MLP
fprintf('Denoising with MLP ... ');
tstart_mlp = tic;
im_denoised_mlp = fdenoiseNeural(im_noisy, sigma, params_MLP);
tstop_mlp = toc(tstart_mlp);
fprintf('Done. Took %f seconds. PSNR: %.2fdB\n',tstop_mlp,getPSNR(im_denoised_mlp,im,255));


% whiten
im_tmp_1 = im_noisy - means(1);
im_tmp_2 = im_denoised_bm3d - means(2);
im_tmp_3 = im_denoised_mlp - means(3);
im_1 = W(1,1)*im_tmp_1 + W(2,1)*im_tmp_2 + W(3,1)*im_tmp_3;
im_2 = W(1,2)*im_tmp_1 + W(2,2)*im_tmp_2 + W(3,2)*im_tmp_3;
im_3 = W(1,3)*im_tmp_1 + W(2,3)*im_tmp_2 + W(3,3)*im_tmp_3;


% combine
fprintf('Combing the results ... ');
tstart_combine = tic;
im_denoised = feval('fdenoiseNeuralCombine', params_combine, im_1, im_2, im_3, sigma);
tstop_combine = toc(tstart_combine);
fprintf('Done. Took %f seconds. PSNR: %.2fdB\n',tstop_combine,getPSNR(im_denoised,im,255));





