% Author: burger
function denoisedIm = fdenoiseNeuralCombine(model, im1,im2,im3 , sigma)

  % load the weights
  load(strcat('neuralweights_',model.name,'.mat'));
  w = {};
  w{1} = w_1;
  w{2} = w_2;
  w{3} = w_3;
  w{4} = w_4;
  w{5} = w_5;
  clear w_1; clear w_2; 
  clear w_3; clear w_4; clear w_5;

  patchSz = sqrt((size(w{1}, 2)-1)/3);
  patchSzOut = sqrt(size(w{length(w)},1));

  p_diff = (patchSz - patchSzOut)/2;
  % check if input is larger than output. In that case, extend the image
  sz = size(im1);
  if (p_diff>0)
    im1 = [fliplr(im1(:,(1:p_diff)+1)) im1 fliplr(im1(:, sz(2)-p_diff:sz(2)-1))];  
    im1 = [flipud(im1((1:p_diff)+1,:)); im1; flipud(im1((sz(1)-p_diff:sz(1)-1), :))];  
    im2 = [fliplr(im2(:,(1:p_diff)+1)) im2 fliplr(im2(:, sz(2)-p_diff:sz(2)-1))];  
    im2 = [flipud(im2((1:p_diff)+1,:)); im2; flipud(im2((sz(1)-p_diff:sz(1)-1), :))];  
    im3 = [fliplr(im3(:,(1:p_diff)+1)) im3 fliplr(im3(:, sz(2)-p_diff:sz(2)-1))];  
    im3 = [flipud(im3((1:p_diff)+1,:)); im3; flipud(im3((sz(1)-p_diff:sz(1)-1), :))];  
  end

  pixel_weights = zeros(patchSzOut);
  mid = ceil(patchSzOut/2);
  sig = floor(patchSzOut/2)/model.weightsSig;
  for i=1:patchSzOut
    for j=1:patchSzOut
      d = sqrt((i-mid)^2 + (j-mid)^2);    
      pixel_weights(i,j) = exp((-d^2)/(2*(sig^2))) / (sig*sqrt(2*pi));
    end
  end
  pixel_weights = pixel_weights/max(pixel_weights(:));


  chunkSize = 1000;

  range_y = 1:model.step:(size(im1,1)-patchSz+1);
  range_x = 1:model.step:(size(im1,2)-patchSz+1);
  if (range_y(end)~=(size(im1,1)-patchSz+1))
    range_y = [range_y (size(im1,1)-patchSz+1)];
  end
  if (range_x(end)~=(size(im1,2)-patchSz+1))
    range_x = [range_x (size(im1,2)-patchSz+1)];
  end

  res = zeros(3* patchSz^2, chunkSize);
  positions_out = zeros(2, chunkSize);

  denoisedIm = zeros(sz);
  wIm = zeros(sz);

  idx = 0;
  for y=range_y
    for x=range_x
      p1 = im1(y:y+patchSz-1, x:x+patchSz-1)';
      p2 = im2(y:y+patchSz-1, x:x+patchSz-1)';
      p3 = im3(y:y+patchSz-1, x:x+patchSz-1)';

      idx = idx + 1;
      res(:,idx) = [p1(:); p2(:); p3(:)];
      positions_out(:,idx) = [y; x];
      if (idx>=chunkSize)
        % predict
        part = res;
        for i=1:length(w)
          part = [part; ones(1, size(part,2))];
          if (i<length(w))
            part = tanh(w{i}*part);
          else
            p_final = w{i}*part;

            patches_w = repmat(pixel_weights(:), [1 size(p_final, 2)]);
            p_final = p_final.*patches_w;

            % place in output 
            for j=1:chunkSize
              tmp_p_y = positions_out(1,j):positions_out(1,j)+patchSzOut-1;
              tmp_p_x = positions_out(2,j):positions_out(2,j)+patchSzOut-1;
              denoisedIm(tmp_p_y,tmp_p_x) = denoisedIm(tmp_p_y,tmp_p_x) + reshape(p_final(:,j),[patchSzOut patchSzOut])';
              wIm(tmp_p_y,tmp_p_x) = wIm(tmp_p_y,tmp_p_x) + reshape(patches_w(:,j),[patchSzOut patchSzOut])';


            end
          end
        end

        idx = 0;
      end
    end
  end
  % predict
  part = res(:,1:idx);
  for i=1:length(w)
    part = [part; ones(1, size(part,2))];
    if (i<length(w))
      part = tanh(w{i}*part);
    else
      p_final = w{i}*part;

      patches_w = repmat(pixel_weights(:), [1 size(p_final, 2)]);
      p_final = p_final.*patches_w;

      % place in output 
      for j=1:size(part,2)
        tmp_p_y = positions_out(1,j):positions_out(1,j)+patchSzOut-1;
        tmp_p_x = positions_out(2,j):positions_out(2,j)+patchSzOut-1;
        denoisedIm(tmp_p_y,tmp_p_x) = denoisedIm(tmp_p_y,tmp_p_x) + reshape(p_final(:,j),[patchSzOut patchSzOut])';
        wIm(tmp_p_y,tmp_p_x) = wIm(tmp_p_y,tmp_p_x) + reshape(patches_w(:,j),[patchSzOut patchSzOut])';

      end
    end
  end

  denoisedIm = denoisedIm./wIm;
  denoisedIm = ((denoisedIm*0.2)+0.5)*255;

  clear w; 
  clear patches_w;
  clear wIm;

return


