"""
Name: func.py
Author: Yuxiang LI (li.yuxiang.nj@gmail.com)
Data: 25/03/2016

Description: This script denoise a image patch by patch using a framing technique, 
        it needs an image file, a MLP model and its weights. In case where a noise 
        image is given, it compares directly the noise to the clean image as a real denoiser.
        
Usage: 1. if you want just a demo, run the script with no argument
       2. if you want to test on your clean image, put its path to the argument 
       3. if you want to compare with other method, provide both clean image and noise image
"""

import argparse
import numpy as np
from func import *


if __name__ == "__main__":

    parser = argparse.ArgumentParser()
    parser.add_argument("--clean", type=str, default="cameraman.png", help="clean image file")
    parser.add_argument("--noise", type=str, default=None, help="noise image file")
    parser.add_argument("--output_prefix", type=str, default="./", help="prefix for output files")
    parser.add_argument("--model", type=str, default="model.json", help="MLP model for denoising")
    parser.add_argument("--weights", type=str, default="weights.h5", help="MLP weights for denoising")
    parser.add_argument("--mat_weights", type=str, default="weights_cvpr.mat", help="MLP weights for denoising")
    parser.add_argument("--sigma", type=float, default=25.0, help="if the noise file is not set, the clean image will be damaged with this sigma")
    parser.add_argument("--step", type=int, default=3, help="step for framing denoising")
    parser.add_argument("--window_sigma", type=int, default=2, help="framing gaussian sigma")
    parser.add_argument('--cpu', dest='cpu', action='store_true', help="desactivate Keras and theano")
    args = parser.parse_args()

    # choose between fast and slow version
    if not args.cpu:
        from backend_gpu import load_model 
        model = load_model(args.model, args.weights)
    else:
        from backend_cpu import load_model
        model = load_model(args.mat_weights)
        
    
    print "Model loaded."

    clean = read_image(args.clean)

    if args.noise is None:
	    noise = clean + np.random.normal(0, args.sigma, clean.shape)  # noise image
	    save_image(noise, args.output_prefix + 'noise.png') 
	    print "Initial PSNR: {}".format(psnr(noise, clean))
    else:
	    noise = read_image(args.noise)

    output = denoise(noise, model, sigma=args.window_sigma, step=args.step)

    print "Denoised PSNR: {}".format(psnr(output, clean))

    save_image(output, args.output_prefix + 'result.png') 

